/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.concurrent.Callable;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Pausable;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.InstallProgressMonitor;
import oracle.install.driver.oui.OUISetupDriver;
import oracle.install.driver.oui.SessionDetails;
import oracle.install.driver.oui.SessionInitProgressMonitor;
import oracle.sysman.oii.oiif.oiifm.OiifmIRootShInfo;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressPhases;

public class SetupJob
extends CompositeJob
implements Callable<Void> {
    private boolean multinodeSetup;
    private boolean sharedHome;
    private SessionDetails sessionDetails;
    private SessionInitProgressMonitor sessionInitMonitor;
    private InstallProgressMonitor installProgressMonitor;
    private OiifmIRootShInfo[] rootScripts;
    private boolean configurationRequired;
    private OUISetupMode ouiSetupMode = OUISetupMode.INSTALL;
    private static final Pausable PAUSABLE = new Pausable(){

        @Override
        public void pause() throws Exception {
            Object driver = SetupDriver.getInstance();
            ((SetupDriver)driver).pause();
        }

        @Override
        public void resume() throws Exception {
            Object driver = SetupDriver.getInstance();
            ((SetupDriver)driver).resume();
        }
    };

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails) {
        this(id, description, weightage, sessionDetails, false, false);
    }

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails, boolean multinodeSetup) {
        this(id, description, weightage, sessionDetails, multinodeSetup, false);
    }

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails, boolean multinodeSetup, boolean sharedHome) {
        super(id, description, weightage);
        this.sessionDetails = sessionDetails;
        Application application = Application.getInstance();
        Resource resource = application.getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
        this.multinodeSetup = multinodeSetup;
        this.sharedHome = sharedHome;
        this.populateJobs(OUISetupMode.INSTALL);
        this.setPausable(PAUSABLE);
    }

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails, OUISetupMode mode) {
        this(id, description, weightage, sessionDetails, mode, false, false);
    }

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails, OUISetupMode mode, boolean multinodeSetup, boolean isShared) {
        super(id, description, weightage);
        this.multinodeSetup = multinodeSetup;
        this.sharedHome = isShared;
        this.sessionDetails = sessionDetails;
        this.ouiSetupMode = mode;
        this.populateJobs(mode);
        this.setPausable(PAUSABLE);
    }

    private void populateJobs(OUISetupMode setupMode) {
        Application application = Application.getInstance();
        Resource resource = application.getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
        switch (setupMode) {
            case INSTALL: {
                CompositeJob initPhase = new CompositeJob((Object)"init", 0.1f);
                initPhase.setHidden(true);
                Job job = new Job((Object)"prepare", resource.getString("setupJob.init.prepare.text", "Prepare", new Object[0]));
                initPhase.add(job);
                this.add(initPhase);
                CompositeJob installPhase = new CompositeJob((Object)"install", 0.9f);
                installPhase.setHidden(true);
                job = new Job(OiifrProgressPhases.INSTALL_PHASE, resource.getString("setupJob.install.copy.text", "Copy files", new Object[0]), 0.6f);
                installPhase.add(job);
                if (!PlatformInfo.getInstance().isWindows()) {
                    job = new Job(OiifrProgressPhases.LINK_PHASE, resource.getString("setupJob.install.link.text", "Link binaries", new Object[0]), 0.2f);
                    installPhase.add(job);
                }
                CompositeJob setup = new CompositeJob("setup", resource.getString("setupJob.install.compositeSetup.text", "Setup", new Object[0]), 0.2f);
                job = new Job(OiifrProgressPhases.INSTALL_PHASE2, resource.getString("setupJob.install.setup.text", "Setup files", new Object[0]), 0.5f);
                job.setHidden(true);
                setup.add(job);
                job = new Job(OiifrProgressPhases.SAVE_INVENTORY_PHASE, resource.getString("setupJob.install.saveinventory.text", "Setup inventory", new Object[0]), 0.2f);
                job.setHidden(true);
                setup.add(job);
                job = new Job(OiifrProgressPhases.POSTINSTALL_PHASE, resource.getString("setupJob.install.finishsetup.text", "Finish Setup", new Object[0]), 0.3f);
                job.setHidden(true);
                setup.add(job);
                installPhase.add(setup);
                if (this.multinodeSetup) {
                    CompositeJob remoteSetup = new CompositeJob("remoteSetup", resource.getString("setupJob.install.remotesetup.text", "Perform remote operations", new Object[0]), 0.2f);
                    if (!this.sharedHome) {
                        job = new Job(OiifrProgressPhases.CLUSTER_PHASE, resource.getString("setupJob.install.remotesetup.text", "Setup remote nodes", new Object[0]), 0.6f);
                        job.setHidden(true);
                        remoteSetup.add(job);
                    }
                    job = new Job(OiifrProgressPhases.ADD_NODE_SAVE_INV_PHASE, resource.getString("setupJob.install.remoteinventorycopy.text", "Setup cluster inventory", new Object[0]), 0.4f);
                    job.setHidden(true);
                    remoteSetup.add(job);
                    installPhase.add(remoteSetup);
                }
                this.add(installPhase);
                this.sessionInitMonitor = new SessionInitProgressMonitor(initPhase, null);
                this.installProgressMonitor = new InstallProgressMonitor(installPhase, null);
                break;
            }
            case CLONE: {
                CompositeJob clonePhase = new CompositeJob((Object)"clone", 0.9f);
                clonePhase.setHidden(true);
                Job job = new Job(OiifrProgressPhases.INSTALL_PHASE, resource.getString("setupJob.install.copy.text", "Copy files", new Object[0]), 0.6f);
                clonePhase.add(job);
                if (!PlatformInfo.getInstance().isWindows()) {
                    job = new Job(OiifrProgressPhases.LINK_PHASE, resource.getString("setupJob.install.link.text", "Link binaries", new Object[0]), 0.2f);
                    this.installProgressMonitor = new InstallProgressMonitor(clonePhase, null);
                    clonePhase.add(job);
                }
                CompositeJob setup = new CompositeJob("setup", resource.getString("setupJob.install.compositeSetup.text", "Setup", new Object[0]), 0.2f);
                job = new Job(OiifrProgressPhases.INSTALL_PHASE2, resource.getString("setupJob.install.setup.text", "Setup files", new Object[0]), 0.5f);
                job.setHidden(true);
                setup.add(job);
                job = new Job(OiifrProgressPhases.SAVE_INVENTORY_PHASE, resource.getString("setupJob.install.saveinventory.text", "Setup inventory", new Object[0]), 0.2f);
                job.setHidden(true);
                setup.add(job);
                job = new Job(OiifrProgressPhases.POSTINSTALL_PHASE, resource.getString("setupJob.install.finishsetup.text", "Finish Setup", new Object[0]), 0.3f);
                job.setHidden(true);
                setup.add(job);
                clonePhase.add(setup);
                this.add(clonePhase);
                this.installProgressMonitor = new InstallProgressMonitor(clonePhase, null);
                break;
            }
            case ADDNODE: {
                CompositeJob initPhase = new CompositeJob((Object)"init", 0.1f);
                initPhase.setHidden(true);
                CompositeJob addnodePhase = new CompositeJob((Object)"Add node", 0.9f);
                addnodePhase.setHidden(true);
                Job job = new Job(OiifrProgressPhases.ADD_NODE_INSTANTIATE_PHASE, resource.getString("ADDNODE_INSTANTIATE_FILES_DESC", "Instantiate files", new Object[0]), 0.09f);
                addnodePhase.add(job);
                if (!this.isSharedHome()) {
                    job = new Job(OiifrProgressPhases.ADD_NODE_COPY_PHASE, resource.getString("ADDNODE_COPY_FILES_DESC", "Copying files to node", new Object[0]), 0.9f);
                    addnodePhase.add(job);
                }
                job = new Job(OiifrProgressPhases.ADD_NODE_SAVE_INV_PHASE, resource.getString("ADDNODE_SAVE_CLUSTER_INVENTORY_DESC", "Saving cluster inventory", new Object[0]), 0.11f);
                addnodePhase.add(job);
                this.add(addnodePhase);
                this.sessionInitMonitor = new SessionInitProgressMonitor(initPhase, null);
                this.installProgressMonitor = new InstallProgressMonitor(addnodePhase, null);
            }
        }
    }

    public boolean isMultinodeSetup() {
        return this.multinodeSetup;
    }

    public boolean isSharedHome() {
        return this.sharedHome;
    }

    public OiifmIRootShInfo[] getRootScripts() {
        return this.rootScripts;
    }

    void setRootScripts(OiifmIRootShInfo[] rootScripts) {
        this.rootScripts = rootScripts;
    }

    public OUISetupMode getOUISetupMode() {
        return this.ouiSetupMode;
    }

    public Callable<Void> getWork() {
        return this;
    }

    @Override
    public Void call() throws Exception {
        Object driver = SetupDriver.getInstance();
        if (driver instanceof OUISetupDriver) {
            OUISetupDriver ouiSetupDriver = (OUISetupDriver)driver;
            ouiSetupDriver.setup(this);
        }
        return null;
    }

    public InstallProgressMonitor getInstallProgressMonitor() {
        return this.installProgressMonitor;
    }

    public SessionInitProgressMonitor getSessionInitMonitor() {
        return this.sessionInitMonitor;
    }

    public SessionDetails getSessionDetails() {
        return this.sessionDetails;
    }

    public boolean isConfigurationRequired() {
        return this.configurationRequired;
    }

    public void setConfigurationRequired(boolean configurationRequired) {
        this.configurationRequired = configurationRequired;
    }

    public static enum OUISetupMode {
        INSTALL,
        CLONE,
        ADDNODE;

    }
}

